
#This has to do with the following bioassays
# Onion - Phoma                               # oni1
# Spinach - Fusarium                          # spi2
# Pepper - Phytophthora capsici               # pep  / pepper
# Red fescue - Laetisaria fuciformis          # fes
# Perennial ryegrass - Laetisaria fuciformis  # per1
# Perennial ryegrass - Puccinia               # per2

# Import data and source code -------------------------------------------------------------
#need to set working directory
#setwd()
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2
all_data$LotCode <- paste(all_data$SeedLot, '_', all_data$BioassayType)

onion2 <- read.csv('OnionPhoma_4Rdata.csv')
onion2$LeafScore <- onion2$LeafScore1to5 *2
onion2$RootScore <- onion2$RootScore1to5

spinach2 <- read.csv('SpinachFusarium_4Rdata.csv')

pepper <- read.csv("Pepper_plant_4Rdata.csv")

perennial_puccinia <- read.csv("Perennial_puccinia_4Rdata.csv") 
perennial_thread <- read.csv('Perennial_thread_4Rdata.csv')
fescue_thread <- read.csv('Red_fescue_4Rdata.csv')

# Reverse directionality for: onion2, spinach2, pepper -----------------------------
onion2$LeafScore.rev <- -(onion2$LeafScore)+11
onion2$RootScore.rev <- -(onion2$RootScore)+5

spinach2$Fus322.rev <- -(spinach2$Fus322)+11
spinach2$Fus254.rev <- -(spinach2$Fus254)+11

pepper$Evaluation1.rev <- -(pepper$Evaluation1)+10
pepper$Evaluation2.rev <- -(pepper$Evaluation2)+10

# Packages ----------------------------------------------------------------
# library(ggplot2)
# library(tidyverse)
# library(ggpubr)
# library(ggrepel)
# 
# library(gridExtra)
# library(cowplot)
# library(ggtext)
# library(ggstance)
# library(ggExtra)
# 
# library(plyr) #ddply for medians for pepper


set_breaks = function(limits) {
  seq(limits[1], limits[2], by = 1)
}


# Onion - Phoma  data prep -----------------------------------------------------------------------

onion2$LotCode <- paste(onion2$SeedLot, '_', 'Onion_Phoma')  
onion2$var1 <- all_data$Bio_var1[match(onion2$LotCode, all_data$LotCode)]
onion2$var2 <- all_data$Bio_var2[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_en <- all_data$Ger_energy[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_cap <- all_data$Ger_capacity[match(onion2$LotCode, all_data$LotCode)]
onion2<-onion2[!(onion2$reject_en=="affected" | onion2$reject_cap=="affected"),]

# Onion - Phoma  variable 2 B2 -----------------------------------------------------------------------
head(onion2)
onion2$SeedLot <- as.character(onion2$SeedLot)

a2.2 <- ggplot(onion2, aes(x=SeedLot, y=LeafScore.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(0.9, 10.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("B2. Onion -"~italic(Setophoma)~~italic(terrestris)~"; leaf symptoms (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Leaf symptoms (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))

a2 <- a2.2 + theme(legend.position='none')

b2 <- ggplot (onion2, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c2.2 <- plot_grid(a2, b2, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

# Add legend -------------------------------------------------------------------
legend <- get_legend((a2.2 + guides(color = 'none')))
c2 <- plot_grid(c2.2, legend, ncol=2, rel_widths = c(1, 0.2))


# Onion - Phoma  variable 1 B1 -----------------------------------------------------------------------

a1.1 <- ggplot(onion2, aes(x=SeedLot, y=RootScore.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(-0.1,5.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Disinfected', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("B1. Onion -"~italic(Setophoma)~~italic(terrestris)~"; root symptoms (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Root symptoms (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))

a1 <- a1.1 + theme(legend.position='none')

b1 <- ggplot (onion2, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() +
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c1.1 <- plot_grid(a1, b1, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

# Add legend -------------------------------------------------------------------
legend <- get_legend((a1.1 + guides(color = 'none')))
c1 <- plot_grid(c1.1, legend, ncol=2, rel_widths = c(1, 0.2))
#
#
#
#
#
#


# Spinach - Fusarium  data prep -----------------------------------------------------------------------

spinach2$LotCode <- paste(spinach2$SeedLot, '_', 'Spinach_Fusarium')  
spinach2$var1 <- all_data$Bio_var1[match(spinach2$LotCode, all_data$LotCode)]
spinach2$var2 <- all_data$Bio_var2[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_en <- all_data$Ger_energy[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_cap <- all_data$Ger_capacity[match(spinach2$LotCode, all_data$LotCode)]
spinach2<-spinach2[!(spinach2$reject_en=="affected" | spinach2$reject_cap=="affected"),]

# Spinach - Fusarium variable 1 E1 -----------------------------------------------------------------------
head(spinach2)
spinach2$SeedLot <- as.character(spinach2$SeedLot)

a3.3 <- ggplot(spinach2, aes(x=SeedLot, y=Fus322.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(0.9, 10.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("E1. Spinach -"~italic(Fusarium)~~italic(oxysporum)~"; strain Fus322 infection (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Infection (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))

a3 <- a3.3 + theme(legend.position='none')


b3 <- ggplot (spinach2, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c3.3 <- plot_grid(a3, b3, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

# Add legend -------------------------------------------------------------------
legend <- get_legend((a3.3 + guides(color = 'none')))
c3 <- plot_grid(c3.3, legend, ncol=2, rel_widths = c(1, 0.2))

# Spinach - Fusarium variable 2 E2 -----------------------------------------------------------------------

a4.4 <- ggplot(spinach2, aes(x=SeedLot, y=Fus254.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(0.9, 10.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("E2. Spinach -"~italic(Fusarium)~~italic(oxysporum)~"; strain Fus254 infection (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Infection (index)", x=element_blank(), color = "Treatment") +
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))

a4 <- a4.4 + theme(legend.position='none')

b4 <- ggplot (spinach2, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c4.4 <- plot_grid(a4, b4, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

# Add legend -------------------------------------------------------------------
legend <- get_legend((a4.4 + guides(color = 'none')))
c4 <- plot_grid(c4.4, legend, ncol=2, rel_widths = c(1, 0.2))
#
#
#
#
#
#

# Pepper PLANTS data prep -------------------------------------------------------------------
head(pepper)
pepper <- na.omit(pepper)

pepper <- ddply(pepper, c('MRTrt', 'SeedLot', 'Replicate'), summarise,
                median.Ev1.rev = median(Evaluation1.rev),
                median.Ev2.rev = median(Evaluation2.rev))

pepper$LotCode <- paste(pepper$SeedLot, '_', 'Pepper plants_Phytophthora capsici')  
pepper$var1 <- all_data$Bio_var1[match(pepper$LotCode, all_data$LotCode)]
pepper$var2 <- all_data$Bio_var2[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_en <- all_data$Ger_energy[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_cap <- all_data$Ger_capacity[match(pepper$LotCode, all_data$LotCode)]
pepper<-pepper[!(pepper$reject_en=="affected" | pepper$reject_cap=="affected"),]

# Pepper - Phytophthora capsici variable 1 G1  -----------------------------------------------------------------------
head(pepper)
pepper$SeedLot <- as.character(pepper$SeedLot)

a5.5 <- ggplot(pepper, aes(x=SeedLot, y=median.Ev1.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(1, 5, 9)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("G1. Pepper plants -"~italic(Phytophthora)~~italic(capsici)~"; disease 7 dpi (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Disease 7 dpo (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +
  guides(size = guide_legend(order = 1), 
         colour = guide_legend(order = 2, override.aes = list(size = 6)))

a5 <- a5.5 + theme(legend.position='none') 


b5 <- ggplot (pepper, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c5.5 <- plot_grid(a5, b5, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

# Pepper - Phytophthora capsici variable 2 G2  -----------------------------------------------------------------------

a6.6 <- ggplot(pepper, aes(x=SeedLot, y=median.Ev2.rev)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(1, 5, 9)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("G2. Pepper plants -"~italic(Phytophthora)~~italic(capsici)~"; disease 14 dpi (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Disease 14 dpo (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +
  guides(size = guide_legend(order = 1), 
         colour = guide_legend(order = 2, override.aes = list(size = 6)))

a6 <- a6.6 + theme(legend.position='none')

b6 <- ggplot (pepper, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c6.6 <- plot_grid(a6, b6, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")
#
#
#
#
#
#

# Red fescue - Laetisaria fuciformis data prep  -------------------------------------------------------------------
head(fescue_thread)

fescue_thread$LotCode <- paste(fescue_thread$SeedLot, '_', 'Red fescue_Laetisaria fuciformis')  
fescue_thread$var1 <- all_data$Bio_var1[match(fescue_thread$LotCode, all_data$LotCode)]

fescue_thread$reject_en <- all_data$Ger_energy[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread$reject_cap <- all_data$Ger_capacity[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread<-fescue_thread[!(fescue_thread$reject_en=="affected" | fescue_thread$reject_cap=="affected"),]


# Red fescue - Laetisaria fuciformis variable 1 I  -----------------------------------------------------------------------
head(fescue_thread)
fescue_thread$SeedLot <- as.character(fescue_thread$SeedLot)

a7.7 <- ggplot(fescue_thread, aes(x=SeedLot, y=Disease)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits = c(0.9,5.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("I. Red fescue -"~italic(Laetisaria)~~italic(fuciformis)~"; Leaf symptoms (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Disease (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))

a7 <- a7.7 + theme(legend.position='none')


b7 <- ggplot (fescue_thread, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c7.7 <- plot_grid(a7, b7, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")
#
#
#
#
#
#

# Perennial ryegrass - Laetisaria fuciformis data prep  -------------------------------------------------------------------
head(perennial_thread)

perennial_thread$LotCode <- paste(perennial_thread$SeedLot, '_', 'Perennial ryegrass_Laetisaria fuciformis')  
perennial_thread$var1 <- all_data$Bio_var1[match(perennial_thread$LotCode, all_data$LotCode)]

perennial_thread$reject_en <- all_data$Ger_energy[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread$reject_cap <- all_data$Ger_capacity[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread<-perennial_thread[!(perennial_thread$reject_en=="affected" | perennial_thread$reject_cap=="affected"),]


# Perennial ryegrass - Laetisaria fuciformis variable 1 J  -----------------------------------------------------------------------
head(perennial_thread)
perennial_thread$SeedLot <- as.character(perennial_thread$SeedLot)

a8.8 <- ggplot(perennial_thread, aes(x=SeedLot, y=Disease)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits = c(0.9,5.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("J. Perennial ryegrass -"~italic(Laetisaria)~~italic(fuciformis)~"; Leaf symptoms (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Disease (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))


a8 <- a8.8 + theme(legend.position='none')


b8 <- ggplot (perennial_thread, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c8.8 <- plot_grid(a8, b8, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")
#
#
#
#
#
#

# Perennial ryegrass - Puccinia data prep  -------------------------------------------------------------------
head(perennial_puccinia)

perennial_puccinia$LotCode <- paste(perennial_puccinia$SeedLot, '_', 'Perennial ryegrass_Puccinia sp.')  
perennial_puccinia$var1 <- all_data$Bio_var1[match(perennial_puccinia$LotCode, all_data$LotCode)]

perennial_puccinia$reject_en <- all_data$Ger_energy[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia$reject_cap <- all_data$Ger_capacity[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia<-perennial_puccinia[!(perennial_puccinia$reject_en=="affected" | perennial_puccinia$reject_cap=="affected"),]


# Perennial ryegrass - Puccinia variable 1 K  -----------------------------------------------------------------------
head(perennial_puccinia)
perennial_puccinia$SeedLot <- as.character(perennial_puccinia$SeedLot)

a9.9 <- ggplot(perennial_puccinia, aes(x=SeedLot, y=Disease)) + 
  geom_count(shape = 20, aes(color=MRTrt), alpha = 0.7,
             position=position_dodgev(0.2)) + 
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits = c(0.9,5.1)) +
  scale_color_manual(values = c("#7570B3", "66A61E"), labels = c('Treated', 'Non-treated'))  + 
  scale_size_continuous(limits = c(1,3), set_breaks, range=c(3,6), name = "Replicates") + 
  theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) + 
  ggtitle("K. Perennial ryegrass -"~italic(Puccinia)~" sp.; Leaf symptoms (index) ") +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  labs(y="Disease (index)", x=element_blank(), color = "Treatment") + 
  removeGridY() +  guides(color = guide_legend(override.aes = list(size = 6)))


a9 <- a9.9 + theme(legend.position='none')


b9 <- ggplot (perennial_puccinia, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) +  theme_void() + 
  theme(plot.margin = margin(0,1,1,1), legend.position = 'none') +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c9.9 <- plot_grid(a9, b9, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")
# rename graphs  -------------------------------------------------------------
aphoma1  <- a1.1
aphoma2  <- a2.2
afusspi1 <- a3.3
afusspi2 <- a4.4
apeppl1  <- a5.5
apeppl2  <- a6.6
afeslat  <- a7.7
aperlat  <- a8.8
aperpuc  <- a9.9

cphoma1  <- c1.1
cphoma2  <- c2.2
cfusspi1 <- c3.3
cfusspi2 <- c4.4
cpeppl1  <- c5.5
cpeppl2  <- c6.6
cfeslat  <- c7.7
cperlat  <- c8.8
cperpuc  <- c9.9

bphoma1 <- b1 #for legend

#
#
#
#
#
#

# NEW legend with all parts  -------------------------------------------------------------

title <- paste("Supplementary Figures")
subheader <- paste("Category")

fullegend1 <- ggplot (onion2, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"),
                     labels = c('Positively responsive seed lots',
                                'Non-responsive seed lots', 
                                'Negatively responsive seed lots')) +
  theme_bw() + theme(legend.title = element_text(size = 12),
                     legend.text = element_text(size = 12)) +
  guides(color=guide_legend(title=(paste0(title,"\n","\n",subheader))))

fullegend2 <- aphoma1 +  theme(legend.position = 'right', 
                               legend.justification = 'centre') + guides(color = 'none')

fullegend3 <- aphoma1 + theme(legend.position = 'right', 
                              legend.justification = 'centre') + guides(size = 'none') +
  labs(colour="Seed disinfection \n treatment")

fullegend <- plot_grid(get_legend(fullegend1),
                    get_legend(fullegend2), 
                    get_legend(fullegend3), 
                    ncol = 3, rel_widths = c(0.5, 0.3, 0.2))

